import i18n from 'sveltekit-i18n';

/** @type {import('sveltekit-i18n').Config} */
const config = ({
    loaders: [

        {
            locale: 'en-us',
            key: 'common',
            loader: async () => (
                await import('./locales/en-us.json')
            ).default,
        },

        {
            locale: 'ps-af',
            key: 'common',
            loader: async () => (
                await import('./locales/ps-af.json')
            ).default,
        },

        {
            locale: 'fa-af',
            key: 'common',
            loader: async () => (
                await import('./locales/fa-af.json')
            ).default,
        },

    ],
});


// export const defaultLocale = 'en-us';

export const {t, locale, locales, loading, loadTranslations} = new i18n(config);