import { loadTranslations} from '$lib/translations';
import {redirect} from "@sveltejs/kit";

/** @type {import('@sveltejs/kit').Load} */
export const load = async ({url, params}) => {

    const {pathname} = url;

    const lang = /** @type { Locales } */ (params.lang || url.pathname.split('/')[1])



    if (!lang) {

        throw redirect(302, url + 'en-us');

    }else{
        await loadTranslations(lang, pathname); // keep this just before the `return`
    }

    return {};
}
